# TDD(Test-Driven-Development)

TDD(테스트 주도 개발)는 반복 테스트를 이용한 소프트웨어 방법론이다.

<img width="520" alt="스크린샷 2022-12-15 오후 1 13 59" src="https://user-images.githubusercontent.com/70997596/207771066-c33d6f92-5c21-43b6-97e8-82e53f0247d0.png">  
[기존 프로세스]
  
기존의 일반적인 개발 프로세스와 다르게 테스트케이스를 작성 한 후 실제 코드를 개발하는 절차를 따른다. 

## TDD 개발주기
<img width="500" alt="스크린샷 2022-12-15 오후 1 14 25" src="https://user-images.githubusercontent.com/70997596/207771168-2e376119-acb0-4bd7-b8b9-3d2bca6f3265.png">


**Red** 단계에서는 실패하는 테스트 코드를 먼저 작성한다.  
**Green** 단계에서는 테스트 코드를 성공시키기 위한 실제 코드를 작성한다.  
**Blue** 단계에서는 중복 코드 제거, 일반화 등의 리팩토링을 수행한다.

<img width="532" alt="스크린샷 2022-12-15 오후 1 14 12" src="https://user-images.githubusercontent.com/70997596/207771222-d50183e3-c514-42c8-abf3-15d813b0878b.png">  

>TDD와 일반적인 개발 방식의 가장 큰 차이점은 테스트 코드를 작성한 뒤에 실제 코드를 작성한다는 것이다.  
>디자인(설계) 단계에서 프로그래밍 목적을 미리 정의하고, 테스트 케이스 작성을 해야한다.  
>테스트 코드를 작성하는 도중 발생하는 예외 사항(버그 및 수정사항)은 테스트 케이스에 추가하고 설계를 개선한다.  
>이후 테스트가 통과된 코드만을 코드 개발 단계에서 실제 코드로 작성한다.

## TDD의 대표적인 툴
### JUnit
JUnit은 전 세계적으로 가장 널리 사용되는 'Java 단위 테스트 프레임워크'이다.  
_(Spring Boot에서 아주 잘 쓰고있습니다)_

### xUnit
JUnit 말고, CUnit(C언어), CPPUnit(C++), PyUnit(Python) 등 다른 언어로도 지원 하는 프레임워크를
xUnit이라고 칭한다.

## TDD 방식의 장점
**보다 튼튼한 객체 지향적인 코드 생산**  
TDD는 코드의 재사용 보장을 명시하므로 TDD를 통한 소프트웨어 개발 시 기능 별 철저한 모듈화가 이뤄진다.  
이는 종속성과 의존성이 낮은 모듈로 조합된 소프트웨어 개발을 가능하게 하며 필요에 따라 모듈을 추가하거나 제거해도 소프트웨어 전체 구조에 영향을 미치치 않게 된다.

**재설계 시간의 단축**  
테스트 코드를 먼저 작성하기 때문에 개발자가 지금 무엇을 해야하는지 분명히 정의하고 개발을 시작하게된다.  
또한 테스트 시나리오를 작성하면서 다양한 예외사항에 대해 생각해 볼 수 있다.  
이는 개발 진행 중 소프트웨어의 전반적인 설계가 변경되는 일을 방지할 수 있다.

**디버깅 시간의 단축**  
사용자의 데이터가 잘못 나온다면 DB의 문제인지, 비즈니스 레이어의 문제인지 UI의 문제인지 실제 모든 레이어들을 전부 디버깅 해야하지만, TDD의 경우 자동화 된 유닛 테스팅을 전제하므로 특정 버그를 손 쉽게 찾아낼 수 있다.

**테스트 문서의 대체 가능**  
주로 SI 프로젝트 진행 과정에서 어떤 요소들이 테스트 되었는지 테스트 정의서를 만든다.  
이것은 단순 통합 테스트문서에 지나지 않는다. 하지만 TDD를 하게 될 경우 테스팅을 자동화 시킴과 동시에 보다 정확한 테스트 근거를 산출 할 수 있다.

**추가 구현의 용의함**  
개발이 완료된 소프트웨어에 어떤 기능을 추가할 때 우려되는 점은 해당 기능이 기존 코드에 어떤 영향을 미칠지 알지 못한다는 것이다.   하지만 TDD의 경우 자동화된 유닛 테스팅을 전제하므로 테스트 기간을 단축시킬 수 있다.

## TDD 방식의 단점
**생산성 저하, 생산비용 증가**  
기존 개발 프로세스에 테스트케이스가 추가되었기 때문에 개발속도가 더 느려지고 생산비용도 증가한다.

## TDD 예시
[프론트엔드](https://www.youtube.com/watch?v=L1dtkLeIz-M)  
[Java](https://www.youtube.com/watch?v=bIeqAlmNRrA)

## 출처
https://hanamon.kr/tdd%EB%9E%80-%ED%85%8C%EC%8A%A4%ED%8A%B8-%EC%A3%BC%EB%8F%84-%EA%B0%9C%EB%B0%9C/
